//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Auto Models
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// Generates a bunch of models for the things that require it
//------------------------------------------------------------------------------------------------------------------------------------------------

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Creates high priority assets
ClientEvents.highPriorityAssets(event => {
	global.compressedBlocks.forEach(entry => {
		entry.model.forEach(model => {
			let base = model.replace(/.*_(compressed_\dx)/, "$1");
			
			event.add("pa2_compressed:models/block/" + model, {
				parent: "pa2_compressed:block/" + base,
				textures: {
					up: entry.texture
				}
			});
		});
	});

    global.teFixer.forEach(entry => {
        entry.models.forEach(model => {
            event.add("thermal_extra:models/" + model[0], {
                parent: "thermal_extra:" + model[1]
            });
        });
    });
});